/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.ench;

import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.TridentEntity;
import net.minecraft.inventory.container.RepairContainer;
import net.minecraft.item.BoneMealItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.CombatRules;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LootingLevelEvent;
import net.minecraftforge.event.entity.player.AnvilRepairEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import shadows.apotheosis.ApotheosisObjects;
import shadows.apotheosis.ench.EnchModule;
import shadows.apotheosis.ench.anvil.AnvilTile;
import shadows.apotheosis.ench.objects.ScrappingTomeItem;
import shadows.apotheosis.ench.table.EnchantingStatManager;

public class EnchModuleEvents {
    Method dropLoot;

    @SubscribeEvent
    public void anvilEvent(AnvilUpdateEvent e) {
        if (e.getLeft().func_77948_v()) {
            if (e.getRight().func_77973_b() == Items.field_221672_ax) {
                ItemStack stack = e.getLeft().func_77946_l();
                EnchantmentHelper.func_82782_a(EnchantmentHelper.func_82781_a((ItemStack)stack).entrySet().stream().filter(ent -> ((Enchantment)ent.getKey()).func_190936_d()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)), (ItemStack)stack);
                e.setCost(1);
                e.setMaterialCost(1);
                e.setOutput(stack);
            } else if (e.getRight().func_77973_b() == ApotheosisObjects.PRISMATIC_WEB) {
                ItemStack stack = e.getLeft().func_77946_l();
                EnchantmentHelper.func_82782_a(EnchantmentHelper.func_82781_a((ItemStack)stack).entrySet().stream().filter(ent -> !((Enchantment)ent.getKey()).func_190936_d()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)), (ItemStack)stack);
                e.setCost(30);
                e.setMaterialCost(1);
                e.setOutput(stack);
                return;
            }
        }
        if ((e.getLeft().func_77973_b() == Items.field_221846_eg || e.getLeft().func_77973_b() == Items.field_221848_eh) && e.getRight().func_77973_b().func_206844_a((ITag)Tags.Items.STORAGE_BLOCKS_IRON)) {
            if (e.getLeft().func_190916_E() != 1) {
                return;
            }
            int dmg = e.getLeft().func_77973_b() == Items.field_221848_eh ? 2 : 1;
            ItemStack out = new ItemStack((IItemProvider)(dmg == 1 ? Items.field_221844_ef : Items.field_221846_eg));
            EnchantmentHelper.func_82782_a((Map)EnchantmentHelper.func_82781_a((ItemStack)e.getLeft()), (ItemStack)out);
            out.func_190920_e(1);
            e.setOutput(out);
            e.setCost(5 + EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185307_s, (ItemStack)e.getLeft()) + EnchantmentHelper.func_77506_a((Enchantment)ApotheosisObjects.SPLITTING, (ItemStack)e.getLeft()) * 2);
            e.setMaterialCost(1);
            return;
        }
        if (e.getLeft().func_77973_b() == ApotheosisObjects.HELLSHELF.func_199767_j() || e.getLeft().func_77973_b() == ApotheosisObjects.SEASHELF.func_199767_j()) {
            if (e.getLeft().func_77973_b() != e.getRight().func_77973_b() || e.getLeft().func_190916_E() != 1) {
                return;
            }
            Enchantment ench = e.getLeft().func_77973_b() == ApotheosisObjects.HELLSHELF.func_199767_j() ? ApotheosisObjects.HELL_INFUSION : ApotheosisObjects.SEA_INFUSION;
            int leftLvl = EnchantmentHelper.func_77506_a((Enchantment)ench, (ItemStack)e.getLeft());
            int rightLvl = EnchantmentHelper.func_77506_a((Enchantment)ench, (ItemStack)e.getRight());
            if (leftLvl == 0 || rightLvl != leftLvl) {
                return;
            }
            if (leftLvl + 1 > EnchModule.getEnchInfo(ench).getMaxLevel()) {
                return;
            }
            ItemStack out = e.getLeft().func_77946_l();
            EnchantmentHelper.func_82782_a((Map)ImmutableMap.of((Object)ench, (Object)(leftLvl + 1)), (ItemStack)out);
            out.func_190920_e(1);
            e.setOutput(out);
            e.setCost(1);
            e.setMaterialCost(1);
            return;
        }
        if (ScrappingTomeItem.updateAnvil(e)) {
            return;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void drops(LivingDropsEvent e) throws Exception {
        Entity attacker = e.getSource().func_76346_g();
        LivingEntity target = e.getEntityLiving();
        if (attacker instanceof PlayerEntity) {
            int knowledge;
            PlayerEntity p = (PlayerEntity)attacker;
            if (p.field_70170_p.field_72995_K) {
                return;
            }
            int scavenger = EnchantmentHelper.func_77506_a((Enchantment)ApotheosisObjects.SCAVENGER, (ItemStack)p.func_184614_ca());
            if (scavenger > 0 && (float)p.field_70170_p.field_73012_v.nextInt(100) < (float)scavenger * 2.5f) {
                if (this.dropLoot == null) {
                    this.dropLoot = ObfuscationReflectionHelper.findMethod(LivingEntity.class, (String)"func_213354_a", (Class[])new Class[]{DamageSource.class, Boolean.TYPE});
                }
                target.captureDrops(new ArrayList());
                this.dropLoot.invoke((Object)target, e.getSource(), true);
                e.getDrops().addAll(target.captureDrops(null));
            }
            if ((knowledge = EnchantmentHelper.func_77506_a((Enchantment)ApotheosisObjects.KNOWLEDGE, (ItemStack)p.func_184614_ca())) > 0 && !(e.getEntity() instanceof PlayerEntity)) {
                int items = 0;
                for (ItemEntity i : e.getDrops()) {
                    items += i.func_92059_d().func_190916_E();
                }
                if (items > 0) {
                    e.getDrops().clear();
                }
                items *= knowledge * 25;
                while (items > 0) {
                    int i = ExperienceOrbEntity.func_70527_a((int)items);
                    items -= i;
                    p.field_70170_p.func_217376_c((Entity)new ExperienceOrbEntity(p.field_70170_p, target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), i));
                }
            }
            ApotheosisObjects.SPEARFISHING.addFishes(e);
        }
    }

    @SubscribeEvent
    public void lifeMend(LivingHealEvent e) {
        ApotheosisObjects.LIFE_MENDING.lifeMend(e);
    }

    @SubscribeEvent
    public void breakSpeed(PlayerEvent.BreakSpeed e) {
        ItemStack stack;
        PlayerEntity p = e.getPlayer();
        if (!p.func_233570_aj_() && EnchantmentHelper.func_185284_a((Enchantment)ApotheosisObjects.STABLE_FOOTING, (LivingEntity)p) > 0 && e.getOriginalSpeed() < e.getNewSpeed() * 5.0f) {
            e.setNewSpeed(e.getNewSpeed() * 5.0f);
        }
        if ((stack = p.func_184614_ca()).func_190926_b()) {
            return;
        }
        int depth = EnchantmentHelper.func_77506_a((Enchantment)ApotheosisObjects.DEPTH_MINER, (ItemStack)stack);
        if (depth > 0 && stack.func_150997_a(e.getState()) > 1.0f) {
            float hardness = e.getState().func_185887_b((IBlockReader)e.getPlayer().field_70170_p, e.getPos());
            e.setNewSpeed(Math.min(29.99f, 7.5f + 4.5f * (float)depth) * hardness);
        }
    }

    @SubscribeEvent
    public void rightClick(PlayerInteractEvent.RightClickBlock e) {
        ItemStack s = e.getItemStack();
        int nbLevel = EnchantmentHelper.func_77506_a((Enchantment)ApotheosisObjects.NATURES_BLESSING, (ItemStack)s);
        if (!e.getEntity().func_225608_bj_() && nbLevel > 0 && BoneMealItem.applyBonemeal((ItemStack)s.func_77946_l(), (World)e.getWorld(), (BlockPos)e.getPos(), (PlayerEntity)e.getPlayer())) {
            s.func_222118_a(6 - nbLevel, (LivingEntity)e.getPlayer(), ent -> ent.func_213334_d(e.getHand()));
            e.setCanceled(true);
            e.setCancellationResult(ActionResultType.SUCCESS);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void applyUnbreaking(AnvilRepairEvent e) {
        if (e.getPlayer().field_71070_bA instanceof RepairContainer) {
            RepairContainer r = (RepairContainer)e.getPlayer().field_71070_bA;
            TileEntity te = r.field_234644_e_.func_221484_a(World::func_175625_s).orElse(null);
            if (te instanceof AnvilTile) {
                e.setBreakChance(e.getBreakChance() / (float)(((AnvilTile)te).getEnchantments().getInt((Object)Enchantments.field_185307_s) + 1));
            }
        }
    }

    @SubscribeEvent
    public void livingHurt(LivingHurtEvent e) {
        LivingEntity src;
        int lvl;
        int level;
        LivingEntity user = e.getEntityLiving();
        if (e.getSource().func_76346_g() instanceof Entity && user.func_70660_b(Effects.field_76429_m) == null && (level = EnchantmentHelper.func_185284_a((Enchantment)ApotheosisObjects.BERSERK, (LivingEntity)user)) > 0) {
            user.field_70172_ad = 0;
            user.func_70097_a(EnchModule.CORRUPTED, (float)(level * level));
            user.func_195064_c(new EffectInstance(Effects.field_76429_m, 200 * level, level - 1));
            user.func_195064_c(new EffectInstance(Effects.field_76420_g, 200 * level, level - 1));
            user.func_195064_c(new EffectInstance(Effects.field_76424_c, 200 * level, level - 1));
        }
        if (e.getSource().func_82725_o() && !e.getSource().func_151517_h() && e.getSource().func_76346_g() instanceof LivingEntity && (lvl = EnchantmentHelper.func_185284_a((Enchantment)ApotheosisObjects.MAGIC_PROTECTION, (LivingEntity)(src = (LivingEntity)e.getSource().func_76346_g()))) > 0) {
            e.setAmount(CombatRules.func_188401_b((float)e.getAmount(), (float)(lvl * 2)));
        }
    }

    @SubscribeEvent
    public void reloads(AddReloadListenerEvent e) {
        e.addListener((IFutureReloadListener)EnchantingStatManager.INSTANCE);
    }

    @SubscribeEvent
    public void looting(LootingLevelEvent e) {
        DamageSource src = e.getDamageSource();
        if (src != null && src.func_76364_f() instanceof TridentEntity) {
            ItemStack triStack = ((TridentGetter)src.func_76364_f()).getTridentItem();
            e.setLootingLevel(EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185304_p, (ItemStack)triStack));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void breakSpeed(BlockEvent.BreakEvent e) {
        ApotheosisObjects.EARTHS_BOON.provideBenefits(e);
        ApotheosisObjects.CHAINSAW.chainsaw(e);
    }

    public static interface TridentGetter {
        public ItemStack getTridentItem();
    }
}

