/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.deadly.objects;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.BookItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.AnvilUpdateEvent;
import shadows.apotheosis.deadly.DeadlyModule;
import shadows.apotheosis.deadly.affix.Affix;
import shadows.apotheosis.deadly.affix.AffixHelper;
import shadows.apotheosis.deadly.affix.EquipmentType;
import shadows.apotheosis.deadly.affix.IAffixSensitiveItem;
import shadows.apotheosis.deadly.affix.LootRarity;

public class AffixTomeItem
extends BookItem
implements IAffixSensitiveItem {
    public static final String TYPE = "apoth.booktype";
    static Random rand = new Random();
    protected final LootRarity field_208075_l;

    public AffixTomeItem(LootRarity rarity, Item.Properties props) {
        super(props);
        this.field_208075_l = rarity;
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (!this.func_77636_d(stack)) {
            tooltip.add((ITextComponent)new TranslationTextComponent("info.apotheosis.affix_tome").func_240699_a_(TextFormatting.GRAY));
            tooltip.add((ITextComponent)new TranslationTextComponent("info.apotheosis.affix_tome2", new Object[]{new TranslationTextComponent("rarity.apoth." + this.field_208075_l.name().toLowerCase(Locale.ROOT)).func_240703_c_(Style.field_240709_b_.func_240718_a_(this.field_208075_l.getColor()))}).func_240699_a_(TextFormatting.GRAY));
        } else {
            if (stack.func_77978_p().func_74764_b(TYPE)) {
                tooltip.add((ITextComponent)new TranslationTextComponent("info.apotheosis.retrieved_from", new Object[]{new TranslationTextComponent("type.apotheosis." + EquipmentType.values()[stack.func_77978_p().func_74762_e(TYPE)].name().toLowerCase(Locale.ROOT))}).func_240699_a_(TextFormatting.BLUE));
            }
            Map<Affix, Float> afx = AffixHelper.getAffixes(stack);
            afx.forEach((a, l) -> tooltip.add(a.getDisplayName(l.floatValue())));
        }
    }

    public ITextComponent func_200296_o() {
        return ((IFormattableTextComponent)super.func_200296_o()).func_230530_a_(Style.field_240709_b_.func_240718_a_(this.field_208075_l.getColor()));
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        return new TranslationTextComponent(this.func_77667_c(stack)).func_230530_a_(Style.field_240709_b_.func_240718_a_(this.field_208075_l.getColor()));
    }

    public boolean func_77636_d(ItemStack stack) {
        return AffixHelper.hasAffixes(stack);
    }

    public LootRarity getRarity() {
        return this.field_208075_l;
    }

    public static boolean updateAnvil(AnvilUpdateEvent ev) {
        ItemStack weapon = ev.getLeft();
        ItemStack book = ev.getRight();
        if (!(book.func_77973_b() instanceof AffixTomeItem)) {
            return false;
        }
        if (!AffixHelper.hasAffixes(book) && AffixHelper.hasAffixes(weapon)) {
            LootRarity rarity = AffixHelper.getRarity(weapon);
            if (rarity == null) {
                return false;
            }
            if (rarity.ordinal() > ((AffixTomeItem)book.func_77973_b()).field_208075_l.ordinal()) {
                return false;
            }
            Map<Affix, Float> wepAfx = AffixHelper.getAffixes(weapon);
            int size = Math.max(1, MathHelper.func_76143_f((double)((double)wepAfx.size() / 2.0)));
            ArrayList<Affix> keys = new ArrayList<Affix>(wepAfx.keySet());
            long seed = 1831L;
            for (Affix e : keys) {
                seed ^= (long)e.getRegistryName().hashCode();
            }
            rand.setSeed(seed ^= (long)ev.getPlayer().func_175138_ci());
            while (keys.size() > size) {
                Affix lost = (Affix)((Object)keys.get(rand.nextInt(keys.size())));
                wepAfx.remove((Object)lost);
                keys.remove((Object)lost);
            }
            ItemStack out = new ItemStack((IItemProvider)DeadlyModule.RARITY_TOMES.get((Object)rarity));
            AffixHelper.setAffixes(out, wepAfx);
            ev.setMaterialCost(1);
            ev.setCost(wepAfx.size() * 18);
            EquipmentType wType = EquipmentType.getTypeFor(weapon);
            if (wType != null) {
                out.func_77978_p().func_74768_a(TYPE, wType.ordinal());
            }
            ev.setOutput(out);
        } else if (AffixHelper.hasAffixes(book)) {
            Map<Affix, Float> bookAfx = AffixHelper.getAffixes(book);
            Map<Affix, Float> wepAfx = AffixHelper.getAffixes(weapon);
            boolean wepTome = weapon.func_77973_b() instanceof AffixTomeItem;
            EquipmentType type = EquipmentType.getTypeFor(weapon);
            if (type == null && !wepTome) {
                return false;
            }
            ITextComponent name = weapon.func_200301_q();
            ItemStack out = weapon.func_77946_l();
            int baseCost = wepAfx.size() * 4;
            int cost = 0;
            for (Map.Entry<Affix, Float> e : bookAfx.entrySet()) {
                Affix afx = e.getKey();
                if (!afx.canApply(type) && !wepTome) continue;
                float curLvl = wepAfx.getOrDefault((Object)afx, Float.valueOf(0.0f)).floatValue();
                if (curLvl == 0.0f) {
                    name = afx.chainName(name, null);
                    wepAfx.put(afx, e.getValue());
                    cost += 12;
                    continue;
                }
                wepAfx.put(afx, Float.valueOf(afx.upgradeLevel(curLvl, e.getValue().floatValue())));
                cost += 18;
            }
            if (cost == 0) {
                return false;
            }
            cost += baseCost;
            if (!wepTome) {
                out.func_200302_a((ITextComponent)((IFormattableTextComponent)name).func_240703_c_(Style.field_240709_b_.func_240718_a_(((AffixTomeItem)book.func_77973_b()).field_208075_l.getColor())));
            }
            AffixHelper.setAffixes(out, wepAfx);
            out.func_190920_e(1);
            ev.setMaterialCost(1);
            ev.setCost(cost);
            ev.setOutput(out);
        }
        return true;
    }

    @Override
    public boolean receivesAttributes(ItemStack stack) {
        return false;
    }

    @Override
    public boolean receivesTooltips(ItemStack stack) {
        return false;
    }
}

