/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.deadly.affix;

import java.util.Random;
import net.minecraft.util.text.Color;
import shadows.apotheosis.deadly.DeadlyModuleClient;
import shadows.apotheosis.deadly.config.DeadlyConfig;

public enum LootRarity {
    COMMON(0x808080, 1),
    UNCOMMON(0x33FF33, 1),
    RARE(0x5555FF, 2),
    EPIC(0xBB00BB, 3),
    MYTHIC(15560724, 3),
    ANCIENT(new DeadlyModuleClient.RainbowColor(), 3);

    final Color color;
    final int affixes;

    private LootRarity(int color, int affixes) {
        this(Color.func_240743_a_((int)color), affixes);
    }

    private LootRarity(Color color, int affixes) {
        this.color = color;
        this.affixes = affixes;
    }

    public Color getColor() {
        return this.color;
    }

    public int getAffixes() {
        return this.affixes;
    }

    public static LootRarity random(Random rand, int min) {
        int range = min + rand.nextInt(1000 - min);
        if (range < DeadlyConfig.rarityThresholds[0]) {
            return COMMON;
        }
        if (range < DeadlyConfig.rarityThresholds[1]) {
            return UNCOMMON;
        }
        if (range < DeadlyConfig.rarityThresholds[2]) {
            return RARE;
        }
        if (range < DeadlyConfig.rarityThresholds[3]) {
            return EPIC;
        }
        if (range < DeadlyConfig.rarityThresholds[4]) {
            return MYTHIC;
        }
        return ANCIENT;
    }

    public static LootRarity random(Random rand) {
        return LootRarity.random(rand, 0);
    }
}

