/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis;

import java.io.File;
import java.util.Collections;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.IModBusEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import shadows.apotheosis.advancements.AdvancementTriggers;
import shadows.apotheosis.compat.PatchouliCompat;
import shadows.apotheosis.deadly.DeadlyModule;
import shadows.apotheosis.deadly.affix.Affix;
import shadows.apotheosis.ench.EnchModule;
import shadows.apotheosis.ench.table.ClueMessage;
import shadows.apotheosis.garden.GardenModule;
import shadows.apotheosis.potion.PotionModule;
import shadows.apotheosis.spawn.SpawnerModule;
import shadows.apotheosis.util.EnchantmentIngredient;
import shadows.apotheosis.util.ModuleCondition;
import shadows.apotheosis.util.ParticleMessage;
import shadows.apotheosis.util.TOPCompat;
import shadows.apotheosis.util.UnenchantedIngredient;
import shadows.apotheosis.village.VillageModule;
import shadows.placebo.config.Configuration;
import shadows.placebo.recipe.NBTIngredient;
import shadows.placebo.recipe.RecipeHelper;
import shadows.placebo.util.NetworkUtils;
import shadows.placebo.util.RunnableReloader;

@Mod(value="apotheosis")
public class Apotheosis {
    public static final String MODID = "apotheosis";
    public static final SimpleChannel CHANNEL = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("apotheosis", "apotheosis")).clientAcceptedVersions(s -> true).serverAcceptedVersions(s -> true).networkProtocolVersion(() -> "1.0.0").simpleChannel();
    public static final RecipeHelper HELPER = new RecipeHelper("apotheosis");
    public static final ItemGroup APOTH_GROUP = new ItemGroup("apotheosis"){

        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)Items.field_221824_dv);
        }
    };
    public static File configDir;
    public static Configuration config;
    public static boolean enableSpawner;
    public static boolean enableGarden;
    public static boolean enableDeadly;
    public static boolean enableEnch;
    public static boolean enablePotion;
    public static boolean enableVillage;
    public static boolean giveBook;
    public static float localAtkStrength;

    public Apotheosis() {
        Affix.classload();
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        if (enableEnch) {
            bus.register((Object)new EnchModule());
        }
        if (enableSpawner) {
            bus.register((Object)new SpawnerModule());
        }
        if (enableGarden) {
            bus.register((Object)new GardenModule());
        }
        if (enableDeadly) {
            bus.register((Object)new DeadlyModule());
        }
        if (enablePotion) {
            bus.register((Object)new PotionModule());
        }
        if (enableVillage) {
            bus.register((Object)new VillageModule());
        }
        if (config.hasChanged()) {
            config.save();
        }
        bus.post((Event)new ApotheosisConstruction());
        bus.addListener(this::init);
        bus.addListener(this::imc);
        MinecraftForge.EVENT_BUS.addListener(this::trackCooldown);
        MinecraftForge.EVENT_BUS.addListener(this::reloads);
        if (ModList.get().isLoaded("patchouli")) {
            PatchouliCompat.register();
        }
    }

    public void imc(InterModEnqueueEvent e) {
        if (ModList.get().isLoaded("theoneprobe")) {
            TOPCompat.register();
        }
    }

    public void init(FMLCommonSetupEvent e) {
        NetworkUtils.registerMessage((SimpleChannel)CHANNEL, (int)0, (NetworkUtils.MessageProvider)new ParticleMessage());
        NetworkUtils.registerMessage((SimpleChannel)CHANNEL, (int)1, (NetworkUtils.MessageProvider)new ClueMessage(0, Collections.emptyList(), false));
        e.enqueueWork(AdvancementTriggers::init);
        CraftingHelper.register((IConditionSerializer)new ModuleCondition.Serializer());
        CraftingHelper.register((ResourceLocation)new ResourceLocation(MODID, "enchantment"), (IIngredientSerializer)EnchantmentIngredient.Serializer.INSTANCE);
        CraftingHelper.register((ResourceLocation)new ResourceLocation(MODID, "unenchanted"), (IIngredientSerializer)UnenchantedIngredient.Serializer.INSTANCE);
    }

    public void reloads(AddReloadListenerEvent e) {
        e.addListener((IFutureReloadListener)RunnableReloader.of(() -> MinecraftForge.EVENT_BUS.post((Event)new ApotheosisReloadEvent())));
    }

    public void trackCooldown(AttackEntityEvent e) {
        PlayerEntity p = e.getPlayer();
        localAtkStrength = p.func_184825_o(0.5f);
    }

    public static Ingredient potionIngredient(Potion type) {
        return new NBTIngredient(PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_151068_bn), (Potion)type));
    }

    static {
        enableSpawner = true;
        enableGarden = true;
        enableDeadly = true;
        enableEnch = true;
        enablePotion = true;
        enableVillage = true;
        giveBook = true;
        localAtkStrength = 1.0f;
        configDir = new File(FMLPaths.CONFIGDIR.get().toFile(), MODID);
        config = new Configuration(new File(configDir, "apotheosis.cfg"));
        enableEnch = config.getBoolean("Enable Enchantment Module", "general", true, "If the enchantment module is enabled.");
        enableSpawner = config.getBoolean("Enable Spawner Module", "general", true, "If the spawner module is enabled.");
        enableGarden = config.getBoolean("Enable Garden Module", "general", true, "If the garden module is loaded.");
        enableDeadly = config.getBoolean("Enable Deadly Module", "general", true, "If the deadly module is loaded.");
        enablePotion = config.getBoolean("Enable Potion Module", "general", true, "If the potion module is loaded.");
        enableVillage = config.getBoolean("Enable Village Module", "general", true, "If the village module is loaded.");
        giveBook = config.getBoolean("Give Book on First Join", "general", true, "If the Chronicle of Shadows is given to new players.");
        if (config.hasChanged()) {
            config.save();
        }
    }

    public static class ApotheosisReloadEvent
    extends Event {
    }

    public static class ApotheosisConstruction
    extends Event
    implements IModBusEvent {
    }
}

