/*
 * Decompiled with CFR 0.152.
 */
package com.thenatekirby.jepb.plugin;

import com.thenatekirby.babel.integration.Mods;
import com.thenatekirby.babel.loot.LootEntryUtil;
import com.thenatekirby.babel.loot.LootFunctionUtil;
import com.thenatekirby.babel.loot.LootTableUtil;
import com.thenatekirby.jepb.plugin.Entry;
import com.thenatekirby.jepb.plugin.PiglinBarteringRecipe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootPredicateManager;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTableManager;
import net.minecraft.loot.LootTables;
import net.minecraft.loot.RandomValueRange;
import net.minecraft.loot.functions.EnchantRandomly;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.loot.functions.SetCount;
import net.minecraft.loot.functions.SetNBT;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IResourcePack;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.resources.SimpleReloadableResourceManager;
import net.minecraft.resources.VanillaPack;
import net.minecraft.util.Unit;
import net.minecraft.util.Util;
import net.minecraft.world.World;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.packs.ModFileResourcePack;

public class PiglinBarteringRecipeBuilder {
    private static LootTableManager manager;

    public static List<PiglinBarteringRecipe> getPiglinBarteringRecipes() {
        LootTable barteringTable = PiglinBarteringRecipeBuilder.getManager((World)Minecraft.func_71410_x().field_71441_e).func_186521_a(LootTables.field_237385_ay_);
        return PiglinBarteringRecipeBuilder.getLootTableItems(barteringTable).stream().map(PiglinBarteringRecipe::new).collect(Collectors.toList());
    }

    private static LootTableManager getManager(@Nullable World world) {
        if (world != null && world.func_73046_m() != null) {
            return world.func_73046_m().func_200249_aQ();
        }
        if (manager != null) {
            return manager;
        }
        manager = new LootTableManager(new LootPredicateManager());
        LinkedList<Object> packs = new LinkedList<Object>();
        packs.add(new VanillaPack(new String[]{Mods.MINECRAFT.getRoot()}));
        for (Object mod : ModList.get().getModFiles()) {
            packs.add(new ModFileResourcePack(mod.getFile()));
        }
        SimpleReloadableResourceManager serverResourceManger = new SimpleReloadableResourceManager(ResourcePackType.SERVER_DATA);
        for (IResourcePack iResourcePack : packs) {
            serverResourceManger.func_199021_a(iResourcePack);
        }
        serverResourceManger.func_219534_a((IFutureReloadListener)manager);
        CompletableFuture future = serverResourceManger.func_219536_a(Util.func_215072_e(), (Executor)Minecraft.func_71410_x(), packs, CompletableFuture.completedFuture(Unit.INSTANCE));
        Minecraft.func_71410_x().func_213161_c(future::isDone);
        return manager;
    }

    private static List<Entry> getLootTableItems(LootTable table) {
        ArrayList<Entry> entries = new ArrayList<Entry>();
        List pools = LootTableUtil.getLootTablePools((LootTable)table);
        pools.forEach(pool -> {
            List lootEntries = LootTableUtil.getLootTableEntries((LootPool)pool);
            lootEntries.stream().filter(entry -> entry instanceof ItemLootEntry).forEach(entry -> {
                Entry lootTableEntry = new Entry(LootEntryUtil.getItem((LootEntry)entry));
                ILootFunction[] functions = LootEntryUtil.getFunctions((LootEntry)entry);
                Arrays.stream(functions).forEach(function -> {
                    IRandomRange randomRange;
                    if (function instanceof SetNBT) {
                        CompoundNBT nbt = LootFunctionUtil.getTag((SetNBT)((SetNBT)function));
                        lootTableEntry.setNBT(nbt);
                    } else if (function instanceof EnchantRandomly) {
                        List enchantments = LootFunctionUtil.getEnchantments((EnchantRandomly)((EnchantRandomly)function));
                        lootTableEntry.setEnchantments(enchantments);
                    } else if (function instanceof SetCount && (randomRange = LootFunctionUtil.getCountRange((SetCount)((SetCount)function))).func_215830_a() == IRandomRange.field_215832_b) {
                        RandomValueRange range = (RandomValueRange)randomRange;
                        lootTableEntry.setRange((int)range.func_186509_a(), (int)range.func_186512_b());
                    }
                });
                entries.add(lootTableEntry);
            });
        });
        return entries;
    }
}

