/*
 * Decompiled with CFR 0.152.
 */
package com.thenatekirby.jepb.plugin;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.thenatekirby.jepb.JEPB;
import com.thenatekirby.jepb.Localization;
import com.thenatekirby.jepb.plugin.PiglinBarteringRecipe;
import com.thenatekirby.jepb.plugin.PiglinBarteringRecipeData;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TranslationTextComponent;

public class JEPBRecipeCategory
implements IRecipeCategory<PiglinBarteringRecipe> {
    static final ResourceLocation UID = JEPB.MOD.withPath("bartering");
    private IGuiHelper guiHelper;
    private IDrawable background;
    private IDrawable icon;
    private final LoadingCache<PiglinBarteringRecipe, PiglinBarteringRecipeData> cachedData;

    JEPBRecipeCategory(IGuiHelper guiHelper, int width, int height) {
        this.guiHelper = guiHelper;
        this.background = guiHelper.createDrawable(JEPB.MOD.withPath("textures/gui/gui_bartering.png"), 0, 0, width, height);
        this.icon = guiHelper.createDrawableIngredient((Object)this.getIconItemStack());
        this.cachedData = CacheBuilder.newBuilder().maximumSize(20L).build((CacheLoader)new CacheLoader<PiglinBarteringRecipe, PiglinBarteringRecipeData>(){

            public PiglinBarteringRecipeData load(@Nonnull PiglinBarteringRecipe key) {
                return new PiglinBarteringRecipeData();
            }
        });
    }

    private ItemStack getIconItemStack() {
        return new ItemStack((IItemProvider)Items.field_151043_k);
    }

    private TranslationTextComponent getLocalizedName() {
        return Localization.PIGLIN_BARTERING;
    }

    @Nonnull
    public ResourceLocation getUid() {
        return UID;
    }

    @Nonnull
    public Class<? extends PiglinBarteringRecipe> getRecipeClass() {
        return PiglinBarteringRecipe.class;
    }

    @Nonnull
    public String getTitle() {
        return this.getLocalizedName().getString();
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(@Nonnull PiglinBarteringRecipe recipe, @Nonnull IIngredients ingredients) {
        ingredients.setInputs(VanillaTypes.ITEM, (List)ImmutableList.of((Object)new ItemStack((IItemProvider)Items.field_151043_k)));
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.getResult());
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull PiglinBarteringRecipe recipe, @Nonnull IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        int y = this.background.getHeight() / 2 - 10;
        guiItemStacks.init(0, true, 13, y);
        guiItemStacks.init(1, false, 112, y);
        guiItemStacks.set(ingredients);
        PiglinBarteringRecipeData data = (PiglinBarteringRecipeData)this.cachedData.getUnchecked((Object)recipe);
        data.setRecipe(recipe);
    }

    public void draw(PiglinBarteringRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        Minecraft minecraft = Minecraft.func_71410_x();
        PiglinBarteringRecipeData data = (PiglinBarteringRecipeData)this.cachedData.getUnchecked((Object)recipe);
        if (data.displayExtraText()) {
            String extraText = data.getExtraText();
            int textColor = -7829368;
            int width = minecraft.field_71466_p.func_78256_a(extraText);
            int x = 121 - width / 2;
            int y = this.background.getHeight() / 2 + 12;
            minecraft.field_71466_p.func_238421_b_(matrixStack, extraText, (float)x, (float)y, textColor);
        }
    }
}

